// Remove Recipes By ID

const recipeIdsToRemove = [
  "irregular_implements:diaphanous_block",
  "mekanism:portable_qio_dashboard",
  "cataclysm:chiseled_purpur_block",
  "draconicevolution:machines/awakened_crafting_injector",
  "draconicevolution:machines/chaotic_crafting_injector",
  "chisel_chipped_integration:convert/copper_metal_to_ingot",
  "chisel_chipped_integration:convert/diamond_metal_to_gem",
  "chisel_chipped_integration:convert/emerald_metal_to_gem",
  "chisel_chipped_integration:convert/gold_metal_to_ingot",
  "chisel_chipped_integration:convert/iron_metal_to_ingot",
  "chisel_chipped_integration:convert/lapis_metal_to_gem",
  "create_connected:crafting/kinetics/item_silo",
  "ftbstuff:diamond_hammer",
  "ftbstuff:gold_hammer",
  "ftbstuff:iron_hammer",
  "ftbstuff:netherite_hammer",
  "ftbstuff:stone_hammer",
  "glassential:glass_light",
  "malum:runic_small_tainted_rock_bricks_wall",
  "malum:runic_small_twisted_rock_bricks_wall",
  "malum:runic_tainted_rock_bricks_wall",
  "malum:runic_tainted_rock_tiles_wall",
  "ae2:inscriber/certus_quartz_dust",
  "malum:runic_twisted_rock_bricks_wall",
  "malum:runic_twisted_rock_tiles_wall",
  "create:crafting/kinetics/hand_crank",
  "industrialforegoing:mycelial_culinary",
  "clavis:lock_pick",
  "laserio:card_holder",
  "ae2:inscriber/fluix_dust",
  "advanced_ae:quantum_infused_dust",
  "minecraft:writable_book",
  "minecraft:crafting_table",
  "rechiseled:chisel",
  "rarcompat:mimi_dust",
  "sophisticatedstorage:shulker_from_chest",
  "supplementaries:awnings/awning_dark_gray",
  "supplementaries:cannon_boat_oak/minecraft/bamboo",
  "supplementaries:stone_tile",
  "justdynathings:stabilizer",
  "justdynathings:creative_goo",
  "artifacts:eternal_steak",
  "avaritia:skullfire_sword",
  "chancecubes:chance_cube_crafting",
  "ftbstuff:stone_rod",
  /^connectedglass/,
  /minecraft:.*(_stained_glass_pane_from|_terracotta|_stained_glass)/,
  /sophisticatedstorage:generic_.*/,
  /mekanism:factory\/.*/,
  "immersiveengineering:crafting/raw_hammercrushing_aluminum",
  "immersiveengineering:crafting/raw_hammercrushing_lead",
  "immersiveengineering:crafting/raw_hammercrushing_nickel",
  "immersiveengineering:crafting/raw_hammercrushing_osmium",
  "immersiveengineering:crafting/raw_hammercrushing_silver",
  "immersiveengineering:crafting/raw_hammercrushing_tin",
  "immersiveengineering:crafting/raw_hammercrushing_uranium",
  "immersiveengineering:crafting/raw_hammercrushing_zinc",
  "industrialforegoing:mycelial_meatallurgic",
  "immersiveengineering:bottling/duroplast_block",
  "immersiveengineering:bottling/duroplast_plate",
  "xycraft:shaped/void_container",
  "torchmaster:megatorch",
  "xp_synthesiser:kill_recorder",
  "irons_spellbooks:inscription_table",
  "ars_nouveau:enchanting_apparatus",
  "ars_nouveau:basic_spell_turret",
  "irons_jewelry:jewelcrafting_station",
  "create:crafting/kinetics/item_vault",
  "create:crafting/kinetics/mechanical_bearing",
  "createaddition:mechanical_crafting/electric_motor",
  "functionalstorage:storage_controller",
  "functionalstorage:framed_storage_controller",
  "ironfurnaces:augments/augment_generator",
  "mekanism:tier_installer/basic",
  "compactmachines:personal_shrinking_device",
  "entangled:item",
  "rftoolsbuilder:builder",
  "ae2:network/crystal_resonance_generator",
  "ae2:network/blocks/energy_energy_acceptor",
  "pipez:energy_pipe",
  "pipez:gas_pipe",
  "pipez:item_pipe",
  "pipez:fluid_pipe",
  "replication:replicator",
  "rftoolsbase:machine_frame",
  "ars_nouveau:blank_thread",
  "ars_nouveau:ring_of_lesser_discount",
  "compactmachines:new_machine_tiny",
  "compactmachines:new_machine_small",
  "compactmachines:new_machine_farming",
  "compactmachines:new_machine_normal",
  "compactmachines:new_machine_large",
  "compactmachines:new_machine_giant",
  "compactmachines:new_machine_colossal",
  "compactmachines:new_machine_soaryn",
  "gateways:hellish_fortress",
  "gateways:basic/enderman",
  "mob_grinding_utils:recipe_mob_swab",
  "mob_grinding_utils:recipe_cursed_feed",
  "justdynathings:ferricore_anvil",
  "apothic_enchanting:library",
  "immersiveengineering:crafting/thermoelectric_generator",
  "functionalstorage:water_generator_upgrade",
  "extendedae:cobblestone_cell",
  "actuallyadditions:phantom_connector",
  "pipez:ultimate_upgrade",
  "ars_nouveau:ring_of_greater_discount",
  "functionalstorage:dripping_upgrade",
  "functionalstorage:obsidian_upgrade",
  "justdynathings:blazegold_anvil",
  "extendedae:water_cell",
  "computercraft:turtle_advanced_upgrade",
  "computercraft:turtle_normal",
  "justdynathings:celestigem_anvil",
  "projecte:watch_of_flowing_time",
  "justdynathings:eclipse_alloy_anvil",
  "oritech:crafting/magnet",
  "mekanism:superheating_element",
  "powah:crafting/energizing_orb",
  "sfm:manager",
  "rftoolspower:powercell_card",
  "rftoolspower:dimensionalcell",
  "rftoolspower:dimensionalcell_simple",
  "refinedstorage:basic_processor",
  "enderio:smelting/refinedstorage/basic_processor",
  "refinedstorage:/mekanism_generated/basic_processor",
  "refinedstorage:basic_processor",
  "refinedstorage:improved_processor",
  "extrastorage:neural_processor",
  "oritech:crafting/particlecollector",
  "enderio:smelting/extrastorage/neural_processor",
  "extrastorage:/mekanism_generated/neural_processor",
  "extrastorage:neural_processor",
  "extrastorage:/mekanism_generated/neural_processor",
  "extrastorage:/mekanism_generated/neural_processor",
  "extrastorage:neural_processor",
  "extrastorage:iron_crafter",
  "extrastorage:gold_crafter",
  "extrastorage:diamond_crafter",
  "extrastorage:netherite_crafter",
  "enderio:smelting/refinedstorage/improved_processor",
  "refinedstorage:/mekanism_generated/improved_processor",
  "refinedstorage:improved_processor",
  "refinedstorage:advanced_processor",
  "enderio:smelting/refinedstorage/advanced_processor",
  "refinedstorage:/mekanism_generated/advanced_processor",
  "refinedstorage:advanced_processor",
  "draconicevolution:tools/dislocator",
  "hostilenetworks:loot_fabricator",
  "hostilenetworks:sim_chamber",
  "tempad:time_steel_shaped",
  "projecte:collector_mk1",
  "enderstorage:ender_tank",
  "enderstorage:ender_chest",
  "psi:programmer",
  "psi:assembler",
  "refinedtypes:part/infinite_energy_storage_part",
  "refinedtypes:part/infinite_source_storage_part",
  "refinedtypes:part/infinite_soul_storage_part",
  "refinedstorage:autocrafter",
  "mekanism:tier_installer/advanced",
  "ae2:network/crafting/cpu_crafting_unit",
  "oritech:compat/powah/energizing/uranite",
  "mekanism_lasers:ore_generator",
  "mekanism_lasers:fluid_generator",
  "mekanism_lasers:laser_amplifier",
  "xycraft:shaped/extractor",
  "xycraft:shaped/glass_viewer_phantom_dark_membrane",
  "rftoolsutility:environmental_controller",
  "shrink:shrinking_device",
  "ae2:network/blocks/controller",
  "ae2:network/parts/storage_bus",
  "modularrouters:modular_router",
  "xnet:controller",
  "pipez:universal_pipe",
  "powah:crafting/reactor_niotic",
  "powah:crafting/reactor_spirited",
  "powah:crafting/reactor_nitro",
  "rftoolsutility:matter_transmitter",
  "rftoolsutility:matter_receiver",
  "ironfurnaces:augments/augment_factory",
  "projecte:collector_mk2",
  "entangled:block",
  "projecte:dm_pedestal",
  "xp_synthesiser:xp_synthesiser",
  "mekanism:tier_installer/elite",
  "ae2:inscriber/logic_processor_press",
  "advanced_ae:reactionchamber",
  "ars_nouveau:warp_scroll",
  "industrialforegoingsouls:soul_laser_base",
  "projecte:collector_mk3",
  "mekanism:tier_installer/ultimate",
  "mekanism:teleporter",
  "mekanism:teleporter_frame",
  "tempad:time_steel_create",
  "justhammers:impact_core",
  "mob_grinding_utils:recipe_nutritious_feed",
  "powah:crafting/aerial_pearl",
  "ars_creo:starbuncle_wheel",
  "justdynathings:ferricore_anvil_smithing",
  "justdynathings:blazegold_anvil_smithing",
  "justdynathings:celestigem_anvil_smithing",
  "justdynathings:eclipse_alloy_anvil_smithing",
  "tesseract:tesseract",
  "justdirethings:portalgun",
  "justdirethings:portalgun_v2",
  "ae2:charger/meteorite_compass",
  "rftoolspower:coalgenerator",
  "projecte:dm_helmet",
  "projecte:dm_chestplate",
  "projecte:dm_leggings",
  "projecte:dm_boots",
  "projecte:dm_sword",
  "projecte:dm_pick",
  "projecte:dm_axe",
  "projecte:dm_shovel",
  "projecte:dm_hoe",
  "projecte:dm_hammer",
  "projecte:rm_helmet",
  "projecte:rm_chestplate",
  "projecte:rm_leggings",
  "projecte:rm_boots",
  "projecte:rm_sword",
  "projecte:rm_pick",
  "projecte:rm_axe",
  "projecte:rm_shovel",
  "projecte:rm_hoe",
  "projecte:rm_hammer",
  "projecte:philosophers_stone",
  "projecte:philosophers_stone_alt",
  "projecte:interdiction_torch",
  "projecte:destruction_catalyst",
  "projecte:black_hole_band",
  "projecte:harvest_goddess_band",
  "projecte:iron_band",
  "routers:router_connector",
  "projecte:ignition_ring",
  "projecte:zero_ring",
  "projecte:swiftwolf_rending_gale",
  "projecte:archangel_smite",
  "projecte:evertide_amulet",
  "projecte:volcanite_amulet",
  "projecte:gem_of_eternal_density",
  "projecte:mercurial_eye",
  "projecte:body_stone",
  "projecte:soul_stone",
  "projecte:mind_stone",
  "explorerscompass:explorers_compass",
  "enderio:travel_anchor",
  "productivemetalworks:melting/ores/coals",
  "productivemetalworks:melting/coals",
  "productivemetalworks:melting/storage_blocks/charcoals",
  "productivemetalworks:melting/storage_blocks/coals",
  "productivemetalworks:alloying/molten_enderium",
  "immersiveengineering:refinery/high_power_biodiesel_create",
  "immersiveengineering:refinery/high_power_biodiesel",
  "chicken_roost:craftingtable/chicken_food_recipe_tier_17",
  "chicken_roost:craftingtable/chicken_food_recipe_tier_16",
  "chicken_roost:craftingtable/chicken_food_recipe_tier_15",
  "chicken_roost:craftingtable/chicken_food_recipe_tier_14",
  "chicken_roost:craftingtable/chicken_food_recipe_tier_13",
  "chicken_roost:craftingtable/chicken_food_recipe_tier_12",
  "chicken_roost:craftingtable/chicken_food_recipe_tier_11",
  "chicken_roost:craftingtable/chicken_food_recipe_tier_23",
  "chicken_roost:craftingtable/chicken_food_recipe_tier_22",
  "chicken_roost:craftingtable/chicken_food_recipe_tier_21",
  "chicken_roost:craftingtable/chicken_food_recipe_tier_31",
  "draconicevolution:machines/crafting_core",
  "oritech:compat/powah/energizing/fluxite",
  "oritech:crafting/refinerymodule",
  "oritech:crafting/promaxe",
  "oritech:crafting/prompick",
  "oritech:crafting/core7",
  "malum:spirit_infusion/adaptive_wheel",
  "bhc:blade_of_vitality",
  "bhc:vigor_bow",
  "mekanismgenerators:generator/gas_burning",
  "ae2:inscriber/calculation_processor_press",
  "refinedstorage:quartz_enriched_iron",
  "megacells:inscriber/accumulation_processor_press",
  "advanced_ae:quantum_processor_press",
  "refinedstorage:quartz_enriched_copper",
  "refinedstorage:machine_casing",
  "refinedstorage:controller",
  "appflux:inscriber/energy_press",
  "projecte:white_alchemical_bag",
  "extendedae:inscriber/crush_entro",
  "advanced_ae:quantum_processor_press_from_iron",
  "ae2:inscriber/ender_dust",
  "ae2:inscriber/sky_stone_dust",
  "refinedstorage:processor_binding",
  "ae2:inscriber/engineering_processor_press",
  "megacells:inscriber/accumulation_processor_press_extra",
  "ae2:inscriber/silicon_press",
  "ae2:network/blocks/inscribers",
  "sfm:cable",
  "projecte:repair_talisman_alt",
  "projecte:repair_talisman",
  "productivelib:upgrades/time",
  "productivelib:upgrades/productivity_2",
  "productivelib:upgrades/anti_teleport",
  "productivelib:upgrades/filter",
  "productivelib:upgrades/gene_sampler",
  "productivelib:upgrades/child",
  "productivelib:upgrades/range",
  "computercraft:turtle_advanced",
  "projecte:relay_mk3",
  "projecte:condenser_mk2",
  "create:mechanical_crafting/extendo_grip",
  "cabletiers:elite_autocrafter",
  "cabletiers:ultra_autocrafter",
  "cabletiers:mega_autocrafter",
  "occultengineering:smelting/silver_ingot",
  "refinedtypes:energy/infinite_energy_storage_block_upgrade",
  "refinedtypes:energy/infinite_energy_storage_disk_upgrade",
  "refinedtypes:soul/infinite_soul_storage_block_upgrade",
  "refinedtypes:soul/infinite_soul_storage_disk_upgrade",
  "refinedtypes:source/infinite_source_storage_disk_upgrade",
  "refinedtypes:source/infinite_source_storage_block_upgrade",
  "gateways:basic/slime",
  "farmersdelight:wheat_dough_from_water",
  "create:mixing/honey",
  "chisel:charcoal/raw",
  "chisel:charcoal/raw_uncraft",
  "chisel:futura/controller",
  "chisel:runic_voidstone/black",
  /^chisel:glassdyed\/.*_bubble/,
  "chisel:marble_pillar/pillar",
  "chisel:red_sandstone_scribbles/scribbles_0",
  "chisel:sandstone_scribbles/scribbles_0",
  "oritech:raw_uranium_blockblockinv",
  "supplementaries:trapped_present_3",
  "enderio:sag_milling/sand",
  "mekanism:compat/ae2/sand_to_silicon",
  "productivemetalworks:alloying/molten_signalum",
];

const recipeTypesToRemove = ["immersiveengineering:arc_recycling", "irregular_implements:custom_crafting_table"];

const removeByOutput = [
  "ars_nouveau:thread_spellpower",
  "fluxnetworks:flux_dust",
  "apotheosis:mythic_material",
  "ars_nouveau:shapers_focus",
  "ars_nouveau:glyph_animate_block",
];

ServerEvents.recipes((event) => {
  recipeIdsToRemove.forEach((recipeId) => {
    event.remove({ id: recipeId });
  });

  removeByOutput.forEach((output) => {
    event.remove({ output: output });
  });

  recipeTypesToRemove.forEach((recipeType) => {
    event.remove({ type: recipeType });
  });
});
